<?php $__env->startSection('content'); ?>
    <div class="cmn-section">
        <div class="container">
            <div class="row justify-content-center">
                <div class="col-md-12">
                    <div class="show-filter mb-3 text-end">
                        <button type="button" class="btn--base showFilterBtn btn-sm"><i class="las la-filter"></i> <?php echo app('translator')->get('Filter'); ?></button>
                    </div>
                    <div class="card responsive-filter-card mb-4">
                        <div class="card-body">
                            <form action="">
                                <div class="d-flex flex-wrap gap-4">
                                    <div class="flex-grow-1">
                                        <label><?php echo app('translator')->get('Transaction Number'); ?></label>
                                        <input type="text" name="search" value="<?php echo e(request()->search); ?>" class="form-control">
                                    </div>
                                    <div class="flex-grow-1">
                                        <label><?php echo app('translator')->get('Wallet Type'); ?></label>
                                        <select name="wallet_type" class="form-control form-select">
                                            <option value=""><?php echo app('translator')->get('All'); ?></option>
                                            <option value="deposit_wallet" <?php if(request()->wallet_type == 'deposit_wallet'): echo 'selected'; endif; ?>><?php echo app('translator')->get('Deposit Wallet'); ?></option>
                                            <option value="interest_wallet" <?php if(request()->wallet_type == 'interest_wallet'): echo 'selected'; endif; ?>><?php echo app('translator')->get('Interest Wallet'); ?></option>
                                        </select>
                                    </div>
                                    <div class="flex-grow-1">
                                        <label><?php echo app('translator')->get('Type'); ?></label>
                                        <select name="trx_type" class="form-control form-select">
                                            <option value=""><?php echo app('translator')->get('All'); ?></option>
                                            <option value="+" <?php if(request()->trx_type == '+'): echo 'selected'; endif; ?>><?php echo app('translator')->get('Plus'); ?></option>
                                            <option value="-" <?php if(request()->trx_type == '-'): echo 'selected'; endif; ?>><?php echo app('translator')->get('Minus'); ?></option>
                                        </select>
                                    </div>
                                    <div class="flex-grow-1">
                                        <label><?php echo app('translator')->get('Remark'); ?></label>
                                        <select class="form-control form-select" name="remark">
                                            <option value=""><?php echo app('translator')->get('Any'); ?></option>
                                            <?php $__currentLoopData = $remarks; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $remark): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <option value="<?php echo e($remark->remark); ?>" <?php if(request()->remark == $remark->remark): echo 'selected'; endif; ?>><?php echo e(__(keyToTitle($remark->remark))); ?></option>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </select>
                                    </div>
                                    <div class="flex-grow-1 align-self-end">
                                        <button class="btn--base w-100"><i class="las la-filter"></i> <?php echo app('translator')->get('Filter'); ?></button>
                                    </div>
                                </div>
                            </form>
                        </div>
                    </div>
                    <div class="card custom--card">
                        <div class="card-body p-0">
                            <div class="table-responsive--md">
                                <table class="table">
                                    <thead>
                                        <tr>
                                            <th><?php echo app('translator')->get('Trx'); ?></th>
                                            <th><?php echo app('translator')->get('Transacted'); ?></th>
                                            <th><?php echo app('translator')->get('Amount'); ?></th>
                                            <th><?php echo app('translator')->get('Post Balance'); ?></th>
                                            <th><?php echo app('translator')->get('Wallet Type'); ?></th>
                                            <th><?php echo app('translator')->get('Detail'); ?></th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php $__empty_1 = true; $__currentLoopData = $transactions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $trx): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                            <tr>
                                                <td>
                                                    <strong><?php echo e($trx->trx); ?></strong>
                                                </td>

                                                <td>
                                                    <?php echo e(showDateTime($trx->created_at)); ?><br><?php echo e(diffForHumans($trx->created_at)); ?>

                                                </td>

                                                <td class="budget">
                                                    <span class="fw-bold <?php if($trx->trx_type == '+'): ?> text--success <?php else: ?> text--danger <?php endif; ?>">
                                                        <?php echo e($trx->trx_type); ?> <?php echo e(showAmount($trx->amount)); ?> <?php echo e($general->cur_text); ?>

                                                    </span>
                                                </td>

                                                <td class="budget">
                                                    <?php echo e(showAmount($trx->post_balance)); ?> <?php echo e(__($general->cur_text)); ?>

                                                </td>

                                                <td>
                                                    <?php if($trx->wallet_type == 'deposit_wallet'): ?>
                                                        <span class="badge bg--info"><?php echo app('translator')->get('Deposit Wallet'); ?></span>
                                                    <?php else: ?>
                                                        <span class="badge bg--primary"><?php echo app('translator')->get('Interest Wallet'); ?></span>
                                                    <?php endif; ?>
                                                </td>

                                                <td><?php echo e(__($trx->details)); ?></td>
                                            </tr>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                            <tr>
                                                <td class="text-muted text-center" colspan="100%"><?php echo e(__($emptyMessage)); ?></td>
                                            </tr>
                                        <?php endif; ?>
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                    <?php if($transactions->hasPages()): ?>
                        <div class="mt-4">
                            <?php echo e(paginateLinks($transactions)); ?>

                        </div>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>
<?php $__env->startPush('script'); ?>
    <script>
        (function($) {
            "use strict";
            $('.showFilterBtn').on('click', function() {
                $('.responsive-filter-card').slideToggle();
            });
        })(jQuery);
    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make($activeTemplate . 'layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/dqezeqqs/worldqfslobstrledger.org/core/resources/views/templates/bit_gold/user/transactions.blade.php ENDPATH**/ ?>