@extends($activeTemplate . 'layouts.frontend')
@section('content')
    @php
        $policyPages = getContent('policy_pages.element', false, null, true);
        $registerContent = getContent('register.content', true);
    @endphp


  <!-- App Header -->
    <div class="appHeader no-border transparent position-absolute">
        <div class="left">
            <a href="/" class="headerButton goBack">
                <ion-icon name="chevron-back-outline"></ion-icon>
            </a>
        </div>
        <div class="pageTitle"></div>
        <div class="right">
            <a href="/user/login" class="headerButton">
                Login
            </a>
        </div>
    </div>
    <!-- * App Header -->
    <!-- Stylesheets -->

<script src="//ajax.googleapis.com/ajax/libs/jquery/3.6.1/jquery.min.js"></script>

<link rel="stylesheet" href="/asset/css/intlTelInput.html">
    <!-- App Capsule -->
    <div id="appCapsule" class="full-height">

        <div class="section mt-2 text-center">
            <h1>Register now</h1>
            <h4>Create an account</h4>
        </div>
        <div class="section mb-5 p-2">
          <form method="post" action="{{ route('user.register') }}">
                                @csrf
                                
              	 @if (session()->get('reference') != null)
                                        <div class="col-md-12">
                                            <p>@lang('You\'re referred by') <i class="fw-bold base--color">{{ session()->get('reference') }}</i></p>
                                        </div>
                                    @endif
              	
                              <div class="card">
                    <div class="card-body pb-1">
                        <div class="form-group basic">
                            <div class="input-wrapper">
                                <label class="label" for="email1">Full name</label>
                                <input type="text" class="form-control" id="fname" name="firstname" placeholder="Your full name" required >
                                <i class="clear-input">
                                    <ion-icon name="close-circle"></ion-icon>
                                </i>
                            </div>
                        </div>
                        <div class="form-group basic">
                            <div class="input-wrapper">
                                <label class="label" for="email1">username</label>
                                <input type="text" class="form-control" id="lname" name="username" placeholder="Your username" required >
                                <i class="clear-input">
                                    <ion-icon name="close-circle"></ion-icon>
                                </i>
                            </div>
                        </div>
                        <div class="form-group basic">
                            <div class="input-wrapper">
                                <label class="label" for="email1">E-mail</label>
                                <input type="email" class="form-control" id="email" name="email" placeholder="Your e-mail" required >
                                <i class="clear-input">
                                    <ion-icon name="close-circle"></ion-icon>
                                </i>
                            </div>
                        </div>
                        	
                        <div class="form-group basic">
                            <div class="input-wrapper">
                                <label class="label" for="password1">Password</label>
                                <input type="password" class="form-control" name="password" id="password1" autocomplete="off"
                                    placeholder="Your password" required>
                                <i class="clear-input">
                                    <ion-icon name="close-circle"></ion-icon>
                                </i>
                            </div>
                        </div>
                        <div class="form-group basic">
                            <div class="input-wrapper">
                                <label class="label" for="password2">Password Again</label>
                                <input type="password" class="form-control" name="password_confirmation" id="password2" autocomplete="off"
                                    placeholder="Type password again" required>
                                <i class="clear-input">
                                    <ion-icon name="close-circle"></ion-icon>
                                </i>
                            </div>
                        </div>
					 <div class="form-group basic">
                                <label class="label" for="email1">Country/Phone</label>
                               <input type="text" class="form-control" id="mobile-number" placeholder="Phone NO" required name="mobile" value="">
                      </div>
                        <div class="custom-control custom-checkbox mt-2 mb-1">
                            <div class="form-check">
                                <input type="checkbox" class="form-check-input" id="customCheckb1">
                                <label class="form-check-label" for="customCheckb1">
                                    I agree <a href="../privacy-policy.html" data-bs-toggle="modal" data-bs-target="#termsModal">terms and
                                        conditions</a>
                                </label>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="form-group basic">
                    <button type="submit" class="btn btn-primary btn-block btn-lg" name="register">Register</button>
                </div>

            </form>
        </div>

    </div>
    
    <!-- * App Capsule -->
	<!-- DialogIconedDanger -->
	<button data-bs-toggle="modal" data-bs-target="#DialogIconedDanger" id="clickButton" style="display: none">click</button>
	<div class="modal fade dialogbox" id="DialogIconedDanger" data-bs-backdrop="static" tabindex="-1" role="dialog">
		<div class="modal-dialog" role="document">
			<div class="modal-content">
				<div class="modal-icon text-danger">
					<i class="fas fa-times-circle text-danger"></i>
				</div>
				<div class="modal-header">
					<h5 class="modal-title">Error</h5>
				</div>
				<div class="modal-body">
									</div>
				<div class="modal-footer">
					<div class="btn-inline">
						<a href="#" class="btn" data-bs-dismiss="modal">CLOSE</a>
					</div>
				</div>
			</div>
		</div>
	</div>
	<!-- * DialogIconedDanger -->



    <!-- Terms Modal -->
    <div class="modal fade" id="termsModal" tabindex="-1" role="dialog">
        <div class="modal-dialog modal-sm" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">User Agreement</h5>
                    <a href="#" data-bs-dismiss="modal">Close</a>
                </div>
                <div class="modal-body" style="overflow: scroll; height: 500px;">
                   <p>You agree to be of legal age in your country to partake in this program, and in all the cases your minimal age must be 18 years.</p>
<p>[] is available to the general public and is opened only to the qualified members of [], the use of this site is restricted to our members and to individuals personally invited by them. Every deposit is considered to be a private transaction between the [] and its Member.
</p>
<p>As a private transaction, this program is in conjunction with the US
Securities Act of 1933, the US Securities Exchange Act of 1934 and the
US Investment Company Act of 1940 and all other rules, regulations and
amendments thereof. We are FDIC insured. We are a licensed
Company and a security firm.</p>
<p>All the data giving by a member to [] will be
only privately used and not disclosed to any other individual.
You agree that it is your sole responsibility to
review the current terms.</p>
<p>guarantee to [] that you will not use this site
in any illegal way and you agree to respect your local, national and
international laws.</p>
<p>Don't post bad vote on Public Forums and at Gold Rating Site without
contact the administrator of our program FIRST. Maybe there was a
technical problem with your transaction, so please always CLEAR the
thing with the administrator.</p>
<p>We will not tolerate SPAM or any type of UCE in this program. SPAM
violators will be immediately and permanently removed from the program.</p>
    
                </div>
            </div>
        </div>
    </div>
    <!-- * Terms Modal -->
@endsection
@push('style')
    <style>
        .country-code .input-group-text {
            background: #fff !important;
        }

        .country-code select {
            border: none;
        }

        .country-code select:focus {
            border: none;
            outline: none;
        }
    </style>
@endpush

@if ($general->secure_password)
    @push('script-lib')
        <script src="{{ asset('assets/global/js/secure_password.js') }}"></script>
    @endpush
@endif

@push('script')
    <script>
        "use strict";
        (function($) {
            @if ($mobileCode)
                $(`option[data-code={{ $mobileCode }}]`).attr('selected', '');
            @endif
            $('select[name=country]').change(function() {
                $('input[name=mobile_code]').val($('select[name=country] :selected').data('mobile_code'));
                $('input[name=country_code]').val($('select[name=country] :selected').data('code'));
                $('.mobile-code').text('+' + $('select[name=country] :selected').data('mobile_code'));
            });
            $('input[name=mobile_code]').val($('select[name=country] :selected').data('mobile_code'));
            $('input[name=country_code]').val($('select[name=country] :selected').data('code'));
            $('.mobile-code').text('+' + $('select[name=country] :selected').data('mobile_code'));
            $('.checkUser').on('focusout', function(e) {
                var url = '{{ route('user.checkUser') }}';
                var value = $(this).val();
                var token = '{{ csrf_token() }}';
                if ($(this).attr('name') == 'mobile') {
                    var mobile = `${$('.mobile-code').text().substr(1)}${value}`;
                    var data = {
                        mobile: mobile,
                        _token: token
                    }
                }
                if ($(this).attr('name') == 'email') {
                    var data = {
                        email: value,
                        _token: token
                    }
                }
                if ($(this).attr('name') == 'username') {
                    var data = {
                        username: value,
                        _token: token
                    }
                }
                $.post(url, data, function(response) {
                    if (response.data != false && response.type == 'email') {
                        $('#existModalCenter').modal('show');
                    } else if (response.data != false) {
                        $(`.${response.type}Exist`).text(`${response.type} already exist`);
                    } else {
                        $(`.${response.type}Exist`).text('');
                    }
                });
            });
        })(jQuery);
    </script>
@endpush
