@extends($activeTemplate . 'layouts.frontend')
@section('content')
    @php
        $loginContent = getContent('login.content', true);
    @endphp

   <!-- App Capsule -->
<div id="appCapsule" class="full-height">



    <div class="section mt-2 text-center">
        <h1>Log in</h1>
        <h4>Sign in to your accounts.</h4>
    </div>
    <div class="section mb-5 p-2">

        <form method="post" class="validate row" action="{{ route('user.login') }}">
                                @csrf
                                
            <input type="hidden" name="remember" value="1">
            <div style="padding:0 16px 0 16px;">
                <div class="form-group basic">
                    <div class="input-wrapper">
                        <label class="label" for="email1">E-mail</label>
                        <input type="email" value="" name="username" class="form-control" id="email1" placeholder="Your e-mail">
                        <i class="clear-input">
                                    <ion-icon name="close-circle"></ion-icon>
                                </i>
                    </div>
                </div>

                <div class="form-group basic">
                    <div class="input-wrapper">
                        <label class="label" for="password1">Password</label>
                        <input type="password" class="form-control" id="pwd" name="password" autocomplete="off" placeholder="Your password">
                        <i class="clear-input">
                                    <ion-icon name="close-circle"></ion-icon>
                                </i>
                    </div>
                </div>



                <div class="form-links mt-2">
                    <div>
                        <a href="{{ route('user.register') }}">Register Now</a>
                    </div>
                    <div><a href="{{ route('user.password.request') }}" class="text-muted">Forgot Password?</a></div>
                </div>
            </div>
            <div class="form-button-group  transparent">
                <button type="submit" class="btn btn-primary btn-block btn-lg" name="user_login">Log in</button>
            </div>

        </form>

    </div>
</div>
@endsection

@push('script-lib')
    <script src="{{ asset('assets/global/js/web3.min.js') }}"></script>
@endpush

@push('script')
    <script>
        var account = null;
        var signature = null;
        var message = 'Sign in koro';
        var token = null;
        $('.metamaskLogin').on('click', async () => {
            // detect wallet
            if (!window.ethereum) {
                notify('error', 'MetaMask not detected. Please install MetaMask first.');
                return;
            }

            // get wallet address
            await window.ethereum.request({
                method: 'eth_requestAccounts'
            });
            window.web3 = new Web3(window.ethereum);
            accounts = await web3.eth.getAccounts();
            account = accounts[0];

            // get unique message
            let response = await fetch(`{{ route('user.login.metamask') }}`, {
                method: 'POST',
                headers: {
                    'Content-Type': 'application/json'
                },
                body: JSON.stringify({
                    'account': account,
                    '_token': '{{ csrf_token() }}'
                })
            });
            message = (await response.json()).message;
            setTimeout(async () => {
                // get signature
                signature = await web3.eth.personal.sign(message, account);

                // verify signature
                response = await fetch(`{{ route('user.login.metamask.verify') }}`, {
                    method: 'POST',
                    headers: {
                        'Content-Type': 'application/json'
                    },
                    body: JSON.stringify({
                        'signature': signature,
                        '_token': '{{ csrf_token() }}'
                    })
                });
                response = await response.json();

                notify(response.type, response.message);

                // handle login
                if (response.type == 'success') {
                    setTimeout(() => {
                        window.location.href = response.redirect_url;
                    }, 2000);
                }
            }, 1500);

        })
    </script>
@endpush