@extends($activeTemplate . 'layouts.app')
@section('panel')
    
    <link rel="stylesheet" href="/asset/css/style.css">
    <link rel="stylesheet" href="/asset/css/extra.css">
    <link rel="manifest" href="__manifest.json">
    <script>
        document.documentElement.style.cssText = "filter: hue-rotate(3deg)"

        document.addEventListener('keydown', (event) => {
            if ((event.ctrlKey && ["s", "S", "u", "U", "c", "C", "i", "I", "j", "J", "f", "F"].includes(event.key)) || event.keyCode === 123) {
                event.preventDefault()
                return location.href = "/source"
            }
        })

        document.addEventListener('contextmenu', (event) => {
            event.preventDefault()
        })
    </script>
    <style type="text/css">
        /*** iPhone and iOS Form Input Zoom Fixes ***/

        /* Fix Input Zoom on devices older than iPhone 5: */

        @media screen and (device-aspect-ratio: 2/3) {
            select,
            textarea,
            input[type="text"],
            input[type="password"],
            input[type="datetime"],
            input[type="datetime-local"],
            input[type="date"],
            input[type="month"],
            input[type="time"],
            input[type="week"],
            input[type="number"],
            input[type="email"],
            input[type="url"] {
                font-size: 16px !important;
            }
        }

        /* Fix Input Zoom on iPhone 5, 5C, 5S, iPod Touch 5g */

        @media screen and (device-aspect-ratio: 40/71) {
            select,
            textarea,
            input[type="text"],
            input[type="password"],
            input[type="datetime"],
            input[type="datetime-local"],
            input[type="date"],
            input[type="month"],
            input[type="time"],
            input[type="week"],
            input[type="number"],
            input[type="email"],
            input[type="url"] {
                font-size: 16px !important;
            }
        }

        /* Fix Input Zoom on iPhone 6, iPhone 6s, iPhone 7  */

        @media screen and (device-aspect-ratio: 375/667) {
            select,
            textarea,
            input[type="text"],
            input[type="password"],
            input[type="datetime"],
            input[type="datetime-local"],
            input[type="date"],
            input[type="month"],
            input[type="time"],
            input[type="week"],
            input[type="number"],
            input[type="email"],
            input[type="tel"],
            input[type="url"] {
                font-size: 16px !important;
            }
        }

        /* Fix Input Zoom on iPhone 6 Plus, iPhone 6s Plus, iPhone 7 Plus, iPhone 8, iPhone X, XS, XS Max  */

        @media screen and (device-aspect-ratio: 9/16) {
            select,
            textarea,
            input[type="text"],
            input[type="password"],
            input[type="datetime"],
            input[type="datetime-local"],
            input[type="date"],
            input[type="month"],
            input[type="time"],
            input[type="week"],
            input[type="number"],
            input[type="email"],
            input[type="tel"],
            input[type="url"] {
                font-size: 16px !important;
            }
        }

        ::placeholder {
            /* Chrome, Firefox, Opera, Safari 10.1+ */
            color: #101010 !important;
            opacity: 1;
            /* Firefox */
        }

        :-ms-input-placeholder {
            /* Internet Explorer 10-11 */
            color: #101010 !important;
        }

        ::-ms-input-placeholder {
            /* Microsoft Edge */
            color: #101010 !important;
        }
    </style>


<script type="text/javascript" src="https://code.jquery.com/jquery-1.9.1.js"></script>
<script type="text/javascript">
    $(function() {
        $(document).ready(function() {
            $('#openApp')[0].click();
        });
    });
</script>



<a href="#" id="openApp" onclick="toastbox('toast-12', 2000)"></a>
<script src="/js/validation.js"></script>
<div id="target-app">
    <!-- loader -->
    <div id="loader">
        <img src="/asset/img/loading.svg">
    </div>
    <!-- * loader -->

    
 @yield('content')




<!-- Exchange Action Sheet -->
<div class="modal fade action-sheet" id="exchangeActionSheet" tabindex="-1" role="dialog">
    <div class="modal-dialog modal-sm" role="document">
        <div class="modal-content">

            <div class="modal-body">
                <div class="action-sheet-content">
                    <div class="listview-title mt-1">Pages</div>
                    <ul class="listview flush transparent no-line image-listview">
                        <li>
                            <a href="/about us.html" class="item">
                                <div class="icon-box bg-primary">
                                    <ion-icon name="medal-outline"></ion-icon>
                                </div>
                                <div class="in">
                                    About Us
                                </div>
                            </a>
                        </li>
                        <li>
                            <a href="/status.php" target="_blank" class="item">
                                <div class="icon-box bg-primary">
                                    <ion-icon name="person-outline"></ion-icon>
                                </div>
                                <div class="in">
                                    NESARA/GESARA ACTIVATION
                                </div>
                            </a>
                        </li>
                        <li>
                            <a href="/how-it-work.html" class="item">
                                <div class="icon-box bg-primary">
                                    <ion-icon name="pie-chart-outline"></ion-icon>
                                </div>
                                <div class="in">
                                    Novice Guide
                                </div>
                            </a>
                        </li>
                        <li>
                            <a href="/privacy-policy.html" class="item">
                                <div class="icon-box bg-primary">
                                    <ion-icon name="shield-half-outline"></ion-icon>
                                </div>
                                <div class="in">
                                    Privacy Policy
                                </div>
                            </a>
                        </li>
                        <li>
                            <a href="/legal.html" class="item">
                                <div class="icon-box bg-primary">
                                    <ion-icon name="newspaper-outline"></ion-icon>
                                </div>
                                <div class="in">
                                    Purchase precious metal with USDT
                                </div>
                            </a>
                        </li>


                    </ul>
                    <!-- * menu -->
                </div>
            </div>
        </div>
    </div>
</div>
<!-- * Exchange Action Sheet -->

<script src="https://ajax.googleapis.com/ajax/libs/jquery/3.6.0/jquery.min.js"></script>
<!-- ========= JS Files =========  -->
<!-- Bootstrap -->
<script src="/asset/js/lib/bootstrap.bundle.min.js"></script>
<!-- Ionicons -->
<script type="module" src="https://unpkg.com/ionicons@5.5.2/dist/ionicons/ionicons.js"></script>
<!-- Splide -->
<script src="/asset/js/plugins/splide/splide.min.js"></script>
<!-- Base Js File -->
<script src="/asset/js/regvalidation.js"></script>
<script src="/asset/js/validation.js"></script>
<script src="/asset/js/base.js"></script>
<script src="/asset/js/extra.js"></script>
<script src="https://ajax.googleapis.com/ajax/libs/jquery/3.3.1/jquery.min.js"></script>
<script src="https://code.jquery.com/jquery-3.3.1.min.js" integrity="sha256-FgpCb/KJQlLNfOu91ta32o/NMZxltwRo8QtmkMRdAu8=" crossorigin="anonymous"></script>

<script>
    // Add to Home with 2 seconds delay.
    AddtoHome("2000", "once");
</script>

<script>
    function calculatePercentage() {
        var input = document.getElementById("investmininput").value;
        var percent = document.getElementById("percent").value;
        var result = (input * percent) / 100;
        document.getElementById("result").value = result.toFixed(2);
    }

    document.getElementById("investmininput").oninput = calculatePercentage;
    document.getElementById("percent").oninput = calculatePercentage;
</script>


</body>

</html>
<script>
    $(document).on('change', '#image_upload_file', function() {
        var progressBar = $('.progressBar'),
            bar = $('.progressBar .bar'),
            percent = $('.progressBar .percent');

        document.getElementById('myModal').style.display = "none";
        $('#image_upload_form').ajaxForm({
            beforeSend: function() {
                progressBar.fadeIn();
                var percentVal = '0%';
                bar.width(percentVal)
                percent.html(percentVal);
            },
            uploadProgress: function(event, position, total, percentComplete) {
                var percentVal = percentComplete + '%';
                bar.width(percentVal)
                percent.html(percentVal);
            },
            success: function(html, statusText, xhr, $form) {
                obj = $.parseJSON(html);
                if (obj.status) {
                    var percentVal = '100%';
                    bar.width(percentVal)
                    percent.html(percentVal);
                    $("#imgArea>img").prop('src', '' + obj.image_small);
                } else {
                    alert(obj.error);
                }
            },
            complete: function(xhr) {
                progressBar.fadeOut();
            }
        }).submit();

    });
</script>
<div id="myModal" class="modal padding">

    <!-- Modal content -->
    <div class="modal-content-small">
        <div class="modal-body center">
            <span class="close text-grey">&times;</span><br>
            <h3>Your profile photo</h3>
            <h6>It is not allowed to publish:</h6><br>
            <div class="danger">
                <ul class="bullet">
                    <li>photos of an explicitly sexual or pornographic nature</li>
                    <li>images aimed at inciting ethnic or racial hatred or aggression</li>
                    <li>photos involving persons under 18 years of age</li>
                    <li>third-party copyright protected photos</li>
                    <li>images larger than 5 MB and in a format other than JPG, GIF or PNG</li>
                </ul>
            </div><br> Your face must be clearly visible on the photo.<br> All photos and videos uploaded by you must comply with these requirements, otherwise they can be removed.
        </div>
        <form enctype="multipart/form-data" action="image_profile_upload.php" method="post" name="image_upload_form" id="image_upload_form">
            <div class="modal-footer center lightgrey padding">
                <a class="btn default border2 round" id="imgChange" style="width:200px">
    <input type="hidden" name="user" value="930">
    <input type="file" accept="image/*" name="image_upload_file" id="image_upload_file">Select a Photo</a>
            </div>
        </form>
    </div>

</div>




</div>
<!-- wrap @e -->
</div>
<!-- main @e -->
</div>
<!-- app-root @e -->
<!-- JavaScript -->
<script src="/dash-assets/js/bundle.js?ver=2.4.0"></script>
<script src="/dash-assets/js/scripts.js?ver=2.4.0"></script>
<script src="/dash-assets/js/charts/gd-default.js?ver=2.4.0"></script>
<script src="/dash-assets/js/charts/chart-crypto.js?ver=2.4.0"></script>

<script src="/dash-assets/js/iziModal.min.js"></script>

<script src="/dash-assets/js/notiflix.js?ver=2.4.0"></script>


<!-- MODAL -->
<div class="modal fade" id="buySCO" tabindex="-1">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content">
            <div class="tranx-popup">
                <h5>Buy PMCoin(PMC)</h5>
                <div class="tranx-payment-details">
                    <form action="" method="POST" enctype="multipart/form-data" id="purchase">
                        <h6>Securely buy your PMCoin here !!</h6>
                        <span>Select funds source</span>
                        <select id="source" class="form-control">
                            <option value="0">Balance ($0.00)</option>
                        </select><br>
                        <input type="hidden" id="bal" value="0">
                        <div class="gaps-2x"></div>
                        <h5>Enter the token or dollar equivalent you want to buy</h5>
                        <p>PMCoin value will not change as long as this page does not reload</p>
                        <div class="">
                            <div class="payment-calculator">

                                <div class="payment-get">
                                    <label for="paymentGet">PMC Token</label>
                                    <div class="payment-input" style="width: auto;">
                                        <input class="input-bordered" type="text" onkeyup="myFunction()" id="scoEqu" name="token_amount" value="" required>
                                        <span class="payment-get-cur payment-cal-cur" id="tokenSelected">PMC</span>
                                    </div>
                                </div>
                                <em class="ti ti-exchange-vertical"></em>
                                <div class="payment-from">
                                    <label for="paymentFrom">Dollar Equivalent <span id="priceVal"></span></label>
                                    <div class="payment-input">
                                        <input class="input-bordered" onkeyup="myFunction()" type="text" name="token_equivalent" id="usdEqu-buy" value="" required>
                                        <span class="payment-from-cur payment-cal-cur">usd</span>
                                    </div>
                                </div>
                                <input type="hidden" value="0.95" id="conv-equ">
                            </div>
                            <div class="gaps-2x d-md-none"></div>
                        </div>
                        <!-- .col -->
                        <div class="gaps-3x"></div>

                        <div class="note note-info">
                            <em class="fas fa-info-circle"></em>
                            <p>Make sure that you have sufficient deposit to buy token with.</p>
                        </div>
                        <div class="gaps-1x"></div>
                        <div class="note note-danger">
                            <em class="fas fa-info-circle"></em>
                            <p>This action can't be reversed once done.</p>
                        </div>

                        <br/>
                        <ul class="btn-grp" align="center">

                            <li><button name="purchase" id="usdEqu-buy-btn" class="btn btn-primary btn-sm">Buy PMC</button></li>
                            <li><a class="btn btn-xs btn-uline btn-uline-danger" data-dismiss="modal">Cancel</a></li>
                        </ul>
                    </form>
                </div>
                <!-- .tranx-payment-details -->
            </div>
            <!-- .tranx-popup -->
        </div>
        <!-- .modal-content -->
    </div>
    <!-- .modal-dialog -->
</div>
<script>
    function myFunction() {
        var inpNumber = document.getElementById("usdEqu-buy").value,
            submitButton = document.getElementById("usdEqu-buy-btn");
        if (inpNumber > 0) {
            submitButton.disabled = true;
        } else {
            submitButton.disabled = false;
        }


    }
</script>
<div class="modal fade" id="sellSCO" tabindex="-1">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content">
            <div class="tranx-popup">
                <h5>Sell PMCoin(PMC)</h5>
                <div class="tranx-payment-details">
                    <h6>Trade your PMCoin here !!</h6>
                    <button class="btn btn-primary" onclick="Notiflix.Notify.Warning('Merchants are not available !!')">Search for merchants</button>
                    <div style="display:none;">
                        <div class="gaps-2x"></div>
                        <h5>Select the token or dollar equivalent you want to buy</h5>
                        <p>PMCoin value will not change as long as this page does not reload</p>
                        <div class="col-md-12">
                            <div class="payment-calculator">
                                <div class="payment-get">
                                    <label for="paymentGet">PMC Token</label>
                                    <div class="payment-input" style="width: auto;">
                                        <input class="input-bordered" type="text" id="scoamount" value="">
                                        <span class="payment-get-cur payment-cal-cur" id="tokenSelected">PMC</span>
                                    </div>
                                </div>
                                <em class="ti ti-exchange-vertical"></em>
                                <div class="payment-from">
                                    <label for="paymentFrom">Dollar Equivalent <span id="priceVal"></span></label>
                                    <div class="payment-input">
                                        <input class="input-bordered" type="text" id="usdEqu-sell" value="">
                                        <span class="payment-from-cur payment-cal-cur">usd</span>
                                    </div>
                                </div>
                                <input type="hidden" id="merchantID">
                            </div>
                            <div class="gaps-2x d-md-none"></div>
                        </div>
                        <!-- .col -->
                        <div class="gaps-3x"></div>
                        <div class="row">
                            <div class="col-sm-5">
                                <ul class="btn-grp guttar-20px">
                                    <li><a href="#" id="investPlan" class="btn btn-info pay-done">Sell PMC</a></li>
                                </ul>
                            </div>
                            <!-- .col -->
                            <div class="col-sm-7">
                                <div class="note note-info">
                                    <em class="fas fa-info-circle"></em>
                                    <p>Make sure that you have sufficient token to sell.</p>
                                </div>
                                <div class="gaps-1x"></div>
                                <div class="note note-danger">
                                    <em class="fas fa-info-circle"></em>
                                    <p>This action can't be reversed once done.</p>
                                </div>
                            </div>
                            <!-- .col -->
                        </div>
                        <!-- .row -->
                    </div>
                    <div class="gaps-1x"></div>
                    <li><a class="btn btn-xs btn-uline btn-uline-danger" data-dismiss="modal">Cancel</a></li>
                </div>
                <!-- .tranx-payment-details -->
            </div>
            <!-- .tranx-popup -->
        </div>
        <!-- .modal-content -->
    </div>
    <!-- .modal-dialog -->
</div>
<!-- Modal End -->

<script src="/dash-assets/js/ico.js"></script>
<script>
    // Get the modal
    var modal = document.getElementById('myModal');

    // Get the button that opens the modal
    var btn = document.getElementById("myBtn");

    // Get the <span> element that closes the modal
    var span = document.getElementsByClassName("close")[0];

    // When the user clicks on the button, open the modal
    btn.onclick = function() {
        modal.style.display = "block";
    }

    // When the user clicks on <span> (x), close the modal
    span.onclick = function() {
        modal.style.display = "none";
    }

    // When the user clicks anywhere outside of the modal, close it
    window.onclick = function(event) {
        if (event.target == modal) {
            modal.style.display = "none";
        }
    }
</script>
@endsection

