
    async function getConversionRates() {
        try {
            const response = await fetch('https://api.coingecko.com/api/v3/simple/price?ids=bitcoin,stellar,ripple,ethereum,tether,dogecoin,litecoin,shiba-inu,solana,xdce-crowd-sale,cardano&vs_currencies=usd&include_24hr_change=true');
            const data = await response.json();

            // Conversion rates and 24hr changes
            const coins = {
                btc: { rate: data.bitcoin.usd, change: data.bitcoin.usd_24h_change },
                xlm: { rate: data.stellar.usd, change: data.stellar.usd_24h_change },
                xrp: { rate: data.ripple.usd, change: data.ripple.usd_24h_change },
                eth: { rate: data.ethereum.usd, change: data.ethereum.usd_24h_change },
                usdt: { rate: data.tether.usd, change: data.tether.usd_24h_change },
                doge: { rate: data.dogecoin.usd, change: data.dogecoin.usd_24h_change },
                ltc: { rate: data.litecoin.usd, change: data.litecoin.usd_24h_change },
                shiba: { rate: data["shiba-inu"].usd, change: data["shiba-inu"].usd_24h_change },
                sol: { rate: data.solana.usd, change: data.solana.usd_24h_change },
                xdc: { rate: data["xdce-crowd-sale"].usd, change: data["xdce-crowd-sale"].usd_24h_change },
                ada: { rate: data.cardano.usd, change: data.cardano.usd_24h_change },
            };

            const userAmounts = {
                btc: parseFloat("{{ showAmount(auth()->user()->btc) }}"),
                xlm: parseFloat("{{ showAmount(auth()->user()->xlm) }}"),
                xrp: parseFloat("{{ showAmount(auth()->user()->xrp) }}"),
                eth: parseFloat("{{ showAmount(auth()->user()->eth) }}"),
                usdt: parseFloat("{{ showAmount(auth()->user()->usdttrc) }}"),
                doge: parseFloat("{{ showAmount(auth()->user()->doge) }}"),
                ltc: parseFloat("{{ showAmount(auth()->user()->ltc) }}"),
                shiba: parseFloat("{{ showAmount(auth()->user()->shiba) }}"),
                sol: parseFloat("{{ showAmount(auth()->user()->sol) }}"),
                xdc: parseFloat("{{ showAmount(auth()->user()->xdc) }}"),
                ada: parseFloat("{{ showAmount(auth()->user()->ada) }}"),
            };

            // Update DOM
            for (const [coin, { rate, change }] of Object.entries(coins)) {
                const userUsd = userAmounts[coin];
                const coinValue = (userUsd / rate).toFixed(coin === 'shiba' ? 2 : 8);
                const changeFixed = change.toFixed(2);
                const isUp = change > 0;

                // Update value
                const valueEl = document.getElementById(`${coin}Value`);
                if (valueEl) valueEl.innerText = `${coinValue} ${coin.toUpperCase()}`;

                // Update change
                const changeEl = document.getElementById(`${coin}Change`);
                if (changeEl) {
                    changeEl.innerHTML = `
                        <i class="fa-solid fa-arrow-${isUp ? 'up' : 'down'}"></i>
                        <span class="${isUp ? 'text-success' : 'text-danger'}">${isUp ? '+' : ''}${changeFixed}%</span>
                    `;
                }
            }
        } catch (error) {
            console.error("Error fetching conversion rates:", error);
        }
    }

    window.onload = getConversionRates;